import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import MonitoraggioSpecieForm from "../../../../core/Forms/MonitoraggioSpecieForm/MonitoraggioSpecieForm";
import {monitoraggioHabitatQuery} from "../../../../api/queries";
import {Button, Card, CardBody, CardText, CardTitle} from "reactstrap";
import AcquaticaDrop from "../../../../core/AcquaticaDrop";
import Loading from "../../../../core/Loading/Loading";
import moment from 'moment';
import 'moment/locale/it';
import {findById} from "../../../../utils";
import ReactTable from "react-table";
import Ionicon from "react-ionicons";

class Detail extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    componentWillMount() {
        moment.locale("it");
    }

    render() {
        const {data} = this.props;

        if(data.loading) {
            return(<Loading/>);
        }

        const {
            monitoraggioHabitat,
            specieProgettos
        } = data;
        const specieProgetto = findById(specieProgettos, monitoraggioHabitat.specie.id);

        return (<div className="container" style={{marginBottom: '20px'}}>
            <div className="row">
                <div className="col">
                    <div className="form-group">
                        <label htmlFor="specie">Specie</label>
                        <Card>
                            <CardBody style={{backgroundColor: "#ffffff"}}>
                                {monitoraggioHabitat.specie && <CardTitle className="ionicon-center">
				<img src={'/LifeEremitaWeb/specie/'+monitoraggioHabitat.specie.id+'.png'} style={{'marginRight':'2em'}} />
                                    {monitoraggioHabitat.specie.denominazioneTaxon}
                                    {<AcquaticaDrop containerStyle={{marginLeft: '0.2em'}} acquatica={specieProgetto.acquatica} specieId={specieProgetto.id}/>}
                                </CardTitle>}

                                {!monitoraggioHabitat.specie && <CardText>
                                    Specie non indicata
                                </CardText>}
                            </CardBody>
                        </Card>
                    </div>
                </div>
            </div>
            <div>
                <div className="row">
                    <div className="col">
                        <h5>Informazioni Generali</h5>
                    </div>
                </div>
                <dl className="row">
                    <dt className="col-sm-3">
                        ID Scheda
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.idScheda}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Sito Natura 2000
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.sitoNatura2000 && monitoraggioHabitat.sitoNatura2000.nome}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Rilevatore/i
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.rilevatori}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Data e Ora Inizio Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.inizioRilievo && moment(monitoraggioHabitat.inizioRilievo).format("LLLL")}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Data e Ora Fine Rilievo
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.fineRilievo && moment(monitoraggioHabitat.fineRilievo).format("LLLL")}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Provincia
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.provincia}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Comune
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.comune}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Località
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.localita}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Transetto
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.transetto}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Lunghezza Transetto
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.lunghezzaTransetto}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Tipologia Monitoraggio
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.tipologiaMonitoraggio && monitoraggioHabitat.tipologiaMonitoraggio.etichetta}
                    </dd>
                </dl>

                <dl className="row">
                    <dt className="col-sm-3">
                        Note
                    </dt>
                    <dd className="col-sm-9">
                        {monitoraggioHabitat.note}
                    </dd>
                </dl>

                <div className="row">
                    <div className="col">
                        <h5>Altre informazioni</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun Metadato Presente"}
                    className="-highlight"
                    data={monitoraggioHabitat.metadati}
                    style={{}}
                    defaultPageSize={100}
		    minRows={0}
		    showPagination={false}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[
                        {
                            Header: "Informazione",
                            accessor: "metadato.descrizione",
                        },
                        {
                            Header: "Valore",
                            accessor: "valore",
                        }
                    ]} />

                <div className="row">
                    <div className="col">
                        <h5>Allegati al Monitoraggio</h5>
                    </div>
                </div>

                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun documento presente"}
                    className="-highlight"
                    data={monitoraggioHabitat.documenti}
                    style={{maxHeight: "300px"}}
                    defaultPageSize={10}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={[
                        {
                            Header: "Nome File",
                            accessor: "nomeFile",
                        },
			{
			     Header: "Scarica",
		  	     Cell: (row) => (
				      <div style={{display: 'flex', alignItems: 'center'}}>
            				  <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
            				    <Button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/download/'+row.original.uuid)}>
          				        <Ionicon icon="ios-download-outline" />
          				      </Button>
           				   </div>
         			     </div>
			     )
			   }
                    ]} />
            </div>
        </div>);
    }
}

export default compose(
    graphql(monitoraggioHabitatQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
)(Detail);

Detail.defaultProps = {};

Detail.propTypes = {};
